---
title: Additional configuration · Cloudflare challenges docs
description: Refer to supported languages for more information.
lastUpdated: 2025-10-13T17:48:00.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-challenges/challenge-types/challenge-pages/additional-configuration/
  md: https://developers.cloudflare.com/cloudflare-challenges/challenge-types/challenge-pages/additional-configuration/index.md
---

## Multi-language support

Refer to [supported languages](https://developers.cloudflare.com/cloudflare-challenges/reference/supported-languages/) for more information.

## Favicon customization

Cloudflare Challenges take the favicon of your website using `GET /favicon.ico` and displays it on the Challenge Page.

You can customize your favicon by using the HTML snippet below.

```html
<link rel="shortcut icon" href="<FAVICON_LINK>" />
```

## Custom Content Security Policy (CSP) and error pages

Cloudflare-served Challenge Pages operate in a strictly controlled environment to maximize security and ensure the challenge mechanism functions correctly. Because of this, you cannot set your own Content Security Policy (CSP) or Referer-Policy using `<meta>` tags or Transform Rules on Challenge Pages. Origin headers can be modified within the Challenge Page context and are not immutable, but they may cause issues.

If you have an active Transform Rule configured to modify HTTP response headers globally across your website, such as adding custom CSP headers, this rule will interfere with and cause the Challenge Page to fail.

To prevent this conflict, you must modify your Transform Rule expression to explicitly exclude Challenge Page error types. Prefix your Transform Rule expression with the following logical exclusion:

```txt
not cf.response.error_type in {"managed_challenge" "iuam" "legacy_challenge" "country_challenge"}
```

This exclusion ensures that your custom header modification logic is only applied to traffic destined for your origin, allowing Cloudflare's Challenge Platform to function without being impacted by conflicting response headers.
