---
title: Supported cloud providers · Cloudflare Rules docs
description: "Cloud Connector currently supports the following cloud providers
  and services:"
lastUpdated: 2025-11-07T13:38:41.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/rules/cloud-connector/providers/
  md: https://developers.cloudflare.com/rules/cloud-connector/providers/index.md
---

Cloud Connector currently supports the following cloud providers and services:

* Cloudflare R2
* Amazon Web Services - S3
* Google Cloud Platform - Cloud Storage
* Microsoft Azure - Blob Storage

## Cloudflare R2

The Cloudflare R2 bucket must be public and [exposed using a custom domain](https://developers.cloudflare.com/r2/buckets/public-buckets/). Buckets exposed using an `r2.dev` subdomain are not supported.

Additionally, the custom domain must be defined in the same zone where you are configuring the Cloud Connector rule.

## Amazon Web Services - S3

The hostname of your S3 bucket URL must have one of the following formats (where `*` is a wildcard character):

* `*s3.amazonaws.com`
* `*s3.<REGION>.amazonaws.com`
* `*s3-website.<REGION>.amazonaws.com`
* `*s3-website-<REGION>.amazonaws.com`

Cloud Connector supports both subdomain and URI path-style URLs:

* **Subdomain-style URLs**: Set the hostname to `<BUCKET_NAME>.s3.amazonaws.com`. In this case, your files are accessible directly under the root of the bucket. For example, `https://example.com/index.html` will map to `https://<BUCKET_NAME>.s3.amazonaws.com/index.html`. When using **Full (Strict)** SSL/TLS mode, the `<BUCKET_NAME>` cannot include dots (use dashes instead). Refer to [SSL connections to AWS S3 endpoints](#ssl-connections-to-aws-s3-endpoints) for details.
* **URI path-style URLs**: Set the hostname to `s3.amazonaws.com`. Here, your bucket name must be part of the URI path in your requests. For example, if your bucket name is `<BUCKET_NAME>`, files will be available on paths like `https://example.com/<BUCKET_NAME>/index.html`, and your Cloud Connector rule should filter traffic based on the URI path starting with `/<BUCKET_NAME>`.

### SSL connections to AWS S3 endpoints

The SSL setting applied to requests between Cloud Connector and AWS S3 depends on the type of S3 endpoint you use:

* **HTTPS-supported endpoints**: For hostnames like `*s3.<REGION>.amazonaws.com` and `*s3.amazonaws.com`, Cloudflare will connect to AWS S3 over HTTPS if you set your zone's SSL/TLS mode to **Full** or **Full (Strict)**. When using **Full (Strict)**, the bucket name cannot include dots (use dashes instead).
* **Non-HTTPS endpoints**: For website-style hostnames such as `*s3-website.<REGION>.amazonaws.com` or `*s3-website-<REGION>.amazonaws.com`, which do not support HTTPS, Cloudflare will default to **Flexible SSL**.

### Get the bucket URL

1. Go to the [Amazon S3 console](https://console.aws.amazon.com/s3/) and select **Buckets** in the navigation pane.
2. Select the bucket name.
3. Go to the **Properties** tab.
4. Select the **Static Website Hosting** card. The **Endpoint** field shows your bucket URL.

For more information, refer to the [Amazon S3 documentation](https://docs.aws.amazon.com/AmazonS3/latest/userguide/EnableWebsiteHosting.html).

Once you configure Cloud Connector with your storage provider's public bucket, you may wish that only Cloudflare can access the objects in that bucket. To achieve this, check your provider's documentation on how to create a policy that only allows incoming requests from [Cloudflare IP addresses](https://www.cloudflare.com/ips/).

## Google Cloud Platform - Cloud Storage

The hostname of your Cloud Storage bucket URL must be the following (where `*` is a wildcard character):

* `*storage.googleapis.com`
* `*storage.cloud.google.com`

Cloud Connector supports both subdomain and URI path-style URLs:

* **Subdomain-style URLs**: Set the hostname to `<BUCKET_NAME>.storage.googleapis.com`. In this case, your files are accessible directly under the root of the bucket. For example, `https://example.com/index.html` will map to `https://<BUCKET_NAME>.storage.googleapis.com/index.html`.
* **URI path-style URLs**: Set the hostname to `storage.googleapis.com`. Here, your bucket name must be part of the URI path in your requests. For example, if your bucket name is `<BUCKET_NAME>`, files will be available on paths like `https://example.com/<BUCKET_NAME>/index.html`, and your Cloud Connector rule should filter traffic based on the URI path starting with `/<BUCKET_NAME>`.

### Get the bucket URL

1. Go to the [Google Cloud console](https://console.cloud.google.com/storage/browser) and select **Buckets**.

2. Select the bucket name.

3. For one of the files already in the bucket, select the link icon in the **Public** column to copy the file's public URL to the clipboard. The file URL will have the following format:

   `https://storage.googleapis.com/<BUCKET_NAME>/<OBJECT_NAME>`

   To obtain the subdomain bucket URL, refactor the file URL to `<BUCKET_NAME>.storage.googleapis.com` format.\
   To obtain the URI path bucket URL, remove `https://` and `/<BUCKET_NAME>/<OBJECT_NAME>` from the file URL.

If the files in your bucket are not publicly accessible, you must change the bucket permissions. For details, refer to the [Google Cloud Storage documentation](https://cloud.google.com/storage/docs/access-control/making-data-public#buckets).

Once you configure Cloud Connector with your storage provider's public bucket, you may wish that only Cloudflare can access the objects in that bucket. To achieve this, check your provider's documentation on how to create a policy that only allows incoming requests from [Cloudflare IP addresses](https://www.cloudflare.com/ips/).

## Microsoft Azure - Blob Storage

The hostname of your Blob Storage bucket URL must have one of the following formats:

* `<BUCKET_NAME>.blob.core.windows.net`
* `<BUCKET_NAME>.web.core.windows.net`

For Azure Blog Storage, Cloud Connector supports only subdomain URLs like `<BUCKET_NAME>.blob.core.windows.net`. This means that your files will be accessible directly under the root of the bucket. For example, `https://example.com/index.html` will map to `https://<BUCKET_NAME>.blob.core.windows.net/index.html`.

### Get the bucket URL

1. Go to the [Azure portal](https://portal.azure.com/) and select your storage account.
2. In the menu pane, under **Settings**, select **Endpoints**.
3. Get your bucket URL from the **Blob service** endpoint or the **Static website** endpoint.

If the blob container is not configured for public access, you must change the container settings. For details, refer to the [Azure Storage documentation](https://learn.microsoft.com/en-us/azure/storage/blobs/anonymous-read-access-configure?tabs=portal).

Once you configure Cloud Connector with your storage provider's public bucket, you may wish that only Cloudflare can access the objects in that bucket. To achieve this, check your provider's documentation on how to create a policy that only allows incoming requests from [Cloudflare IP addresses](https://www.cloudflare.com/ips/).
